/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;
import java.util.List;

/**
 * Vlastnost zpomalení zpomalí všechny ostatní živé hady na poloviční rychlost.
 *
 * @author Daniel Vala
 */
public class StrojCasu extends Ability {

	/**
	 * Vytvoří vlastnost tank s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public StrojCasu(int sance) {
		super(sance);
	}

	/**
	 * Had zpomalí všechny ostatní živé hady na poloviční rychlost.
	 * Pokud už ale je některý živých hadů už zpomalen, tato vlastnost se neprovede.
	 *
	 * @param model Model hry.
	 * @param had   Had, který zpomalí všechny živé hady kromě sebe.
	 * @return True, pokud had ostatní hady zpomalil. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		List<Snake> hadi = model.getZiviHadi();
		// zjištění, zda některý z hadů už není zpomalen
		for (Snake snake : hadi) {
			if (snake.isVlastnostZpomaleny()) {
				return false;
			}
		}
		// zpomalení všech hadů kromě mě
		for (Snake snake : hadi) {
			if (!snake.equals(had)) {
				snake.setVlastnostZpomaleni(true);
			}
		}
		model.getPanelZprav().addMessage(String.format("%s zpomalil všechny ostatní hady!", had));
		return true;
	}
}
