/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;
import java.util.List;
import java.util.Random;

/**
 * Vlastnost swap prohodí hada s jiným, náhodně vybraným živým hadem.
 *
 * @author Daniel Vala
 */
public class Swap extends Ability {

	/**
	 * Vytvoří vlastnost swap s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Swap(int sance) {
		super(sance);
	}

	/**
	 * Prohodí hada s jiným, náhodně vybraným živým hadem.
	 *
	 * @param model Model hry.
	 * @param had   Had, který se prohodí s jiným, náhodným hadem.
	 * @return True, pokud se podařilo hada prohodit. Ve výjimečném případě false, pokud se hada prohodit nepodaří.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		List<Snake> ziviHadi = model.getZiviHadi();
		int nahoda;
		Random generatorNahody = new Random();
		for (int i = 0; i < 300; i++) { // 300 pokusů na přehození
			nahoda = generatorNahody.nextInt(ziviHadi.size());
			// pokud had, se kterým se mám prohodit, nejsem já, hadi se prohodí
			if (!ziviHadi.get(nahoda).equals(had)) {
				had.swapSnakes(ziviHadi.get(nahoda));
				model.getPanelZprav().addMessage(String.format("%s se prohodil s hráčem %s ", had, ziviHadi.get(nahoda)));
				return true;
			}
		}
		return false;
	}
}
