/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Snake can stop. When he does, creates a shield on his body and head.
 *
 * @author Daniel Vala
 */
public class Turtle extends Ability {

	/**
	 * Create ability turtle with given rarity.
	 *
	 * @param chance Propability of generaing this ability.
	 */
	public Turtle(int chance) {
		super(chance);
	}

	/**
	 * Had získá schopnost zastavení.
	 *
	 * @param model Model hry.
	 * @param snake Had, který získá schopnost zastavení.
	 * @return True, pokud had vlastnost získal. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake snake) {
		boolean uspech = snake.setVlastnostTurtle(true);
		if (uspech) {
			model.getPanelZprav().addMessage(String.format("%s sebral želvu a získal schopnost zakuklit se.", snake));
		}
		return uspech;
	}
}
