/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.ai;

import com.serponix.game.GameModel;
import com.serponix.game.Player;
import com.serponix.game.Snake;
import java.util.Random;

/**
 * The abstract class <code>AI</code> is the superclass of all Artificial Intelligence
 * classes.
 * Subclasses must provide method <code>setNewDirection</code> to set new direction
 * of AI player in the next step of the game.
 *
 * @author Daniel Vala
 */
public abstract class AI {

	/**
	 * Length of the snake, when its behavior should be concentrated to eating food.
	 */
	protected final int CRITICAL_LENGTH = 8;

	/**
	 * If only this amount of cells remain to win, snake`s behavior should concentrate to eating food.
	 */
	protected final int LOOK_AT_WIN_CELLS_REMAIN = 6;

	protected Random randomGenerator;
	protected GameModel model;
	protected Player player;
	protected Snake snake;

	public AI(GameModel model, Player player) {
		randomGenerator = new Random();
		this.model = model;
		this.player = player;
		this.snake = player.getSnake();
	}

	/**
	 * Set a new direction of AI.
	 * Direction can be the same as before or changed.
	 * This method should be called each step of the game, not just
	 * when AI snake is moved because of remembering of the game situation.
	 */
	public abstract void setNewDirection();
}