/**
 * Serponix is an arcade game in focus to multiplayer based on the classic game
 * Snake. Copyright (C) 2010 Daniel Vala
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * If you have any question do not hesitate to contact author on e-mail address:
 * danielvala42@gmail.com
 */
package com.serponix.game;

import java.io.File;

/**
 * @author vala
 */
public class Consts {

	public static final String NAME_OF_APPLICATION = "Serponix";
	public static final String WEBSITES = "www.serponix.com";
	public static final int SIZE_OF_BOX = 10;
	public static final int MIN_SPEED_OF_THE_GAME = 0;
	public static final int MAX_SPEED_OF_THE_GAME = 100;
	public static final String GAME_DIR;

	public static final int MINIMUM_CHARACTERS_OF_PLAYER_NAME = 1;
	public static final int MAXIMUM_CHARACTERS_OF_PLAYER_NAME = 10;
	public static final int MAXIMUM_CHARACTERS_OF_SERVER_IP = 15;
	public static final int MIN_PORT = 1;
	public static final int MAX_PORT = 65535;

	static {
		GAME_DIR = getGameDirectory();
	}

	/**
	 * Returns path to directory, where all user files are placed. In Windows 7
	 * it is directory My Games located in user folder. In other operation
	 * systems it is a user folder.
	 *
	 * @return Path to directory, where all user files are placed.
	 */
	private static String getGameDirectory() {
		if (System.getProperty("os.name").contains("Linux")) {
			return System.getProperty("user.home") + File.separator + NAME_OF_APPLICATION + File.separator;
		} else if (System.getProperty("os.name").contains("Windows XP")) {
			return System.getProperty("user.home") + File.separator + NAME_OF_APPLICATION + File.separator;
		} else if (System.getProperty("os.name").contains("Windows 7")) {
			return System.getProperty("user.home") + File.separator + "Documents" + File.separator + "My Games" + File.separator + NAME_OF_APPLICATION + File.separator;
		} else {
			return System.getProperty("user.home") + File.separator + NAME_OF_APPLICATION + File.separator;
		}
	}
}
