/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.settings.GameSettings;
import com.serponix.settings.SnakeAction;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;

/**
 * Zjistí, zda bylo stisknuto některé z tlačítek, které je namapované na akci ovládání hada serveru.
 * Pokud ano, provede příslušnou akci.
 *
 * @author Daniel Vala
 */
public class ControllerHracServer extends KeyAdapter {

	private Player player;
	private Snake had;
	private Map<SnakeAction, Integer> keys;

	/**
	 * Vytvoří controller pro ovládání hada pro hráče na serveru.
	 *
	 * @param player Hráč, který bude controllerem ovládán.
	 */
	public ControllerHracServer(Player player) {
		this.player = player;
		this.had = player.getSnake();
		keys = GameSettings.getInstance().getKeysOfGivenPlayer(Player.Control.getCisloKlavesnice(player.getOvladani()));
	}

	@Override
	public void keyPressed(KeyEvent event) {
		int key = event.getKeyCode();

		if (key == keys.get(SnakeAction.RIGHT)) {
			player.changeSmer(Direction.RIGHT);
		} else if (key == keys.get(SnakeAction.LEFT)) {
			player.changeSmer(Direction.LEFT);
		} else if (key == keys.get(SnakeAction.UP)) {
			player.changeSmer(Direction.UP);
		} else if (key == keys.get(SnakeAction.DOWN)) {
			player.changeSmer(Direction.DOWN);
		} else if (key == keys.get(SnakeAction.FIRE)) {
			had.strelLaser();
		} else if (key == keys.get(SnakeAction.FIRE2)) {
			had.strelRaketu();
		}
		//        else if (key == KeyEvent.VK_9) {
		//            player.zapniAI();
		//        } else if (key == KeyEvent.VK_0) {
		//            player.vypniAI();
		//        }
	}
}
