/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;

/**
 * Controller pro ovládání společných akcí hry na tomto počítači na serveru,
 * jako je pozastavení hry či její ukončení.
 *
 * @author Daniel Vala
 */
public class ControllerServer extends KeyAdapter {

	private GameModel model;

	/**
	 * Vytvoří controller pro server, který obsluhuje společná tlačítka hry.
	 *
	 * @param model Model hry
	 */
	public ControllerServer(GameModel model) {
		this.model = model;
	}

	@Override
	public void keyPressed(KeyEvent event) {
		int key = event.getKeyCode();

		if (key == KeyEvent.VK_P) {
			model.pauza();
		} else if (key == KeyEvent.VK_F8) {
			if (!model.isHumanPlaying()) {
				model.newRound();
			}
		} else if (key == KeyEvent.VK_ESCAPE) {
			zeptejSeNaKonecHry();
		} else if (key == KeyEvent.VK_Q) {
			if ((event.getModifiers() & InputEvent.CTRL_MASK) != 0) {
				model.ukonciHru();
			}
		}
		//        else if (key == KeyEvent.VK_W) {
		//            if ((event.getModifiers() & InputEvent.CTRL_MASK) != 0) {
		//                model.ladeni = !model.ladeni;
		//            }
		//        } else if (key == KeyEvent.VK_I) {
		//            if (model.ladeni) {
		//                model.zobrazVeciNaPlose = !model.zobrazVeciNaPlose;
		//            }
		//        } else if (key == KeyEvent.VK_O) {
		//            if (model.ladeni) {
		//                model.krokovani = !model.krokovani;
		//            }
		//        } else if (key == KeyEvent.VK_L) {
		//            if (model.krokovani) {
		//                model.krok();
		//            }
		//        }
	}

	/**
	 * Zobrazí dialogové okno, zda si hráč přeje opravdu ukončit hru.
	 * Dle výběr ji buď ukončí nebo neudělá nic.
	 */
	private void zeptejSeNaKonecHry() {
		model.zastavHru();
		Object[] options = { "Ano", "Ne" };
		int vyber = JOptionPane.showOptionDialog(null, "Opravdu chcete zrušit hru? \n Všichni připojení hráči budou odpojeni.", "Upozornění", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[1]);
		if (vyber != 0) {
			model.pokracuj();
			return;
		}
		model.ukonciHru();
	}
}
