/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.gui.MainPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * JPanel of the game itself. Contains panel with score, panel with the gaming area and panel with messages.
 *
 * @author Daniel Vala
 */
public class GamePanel extends JPanel {

	private GamingArea gamingArea;

	public GamePanel(MainPanel mainPanel, GameParameters gameParameters) {
		setLayout(new BorderLayout());

		JPanel scorePanel = new JPanel(new FlowLayout());
		scorePanel.setBackground(new Color(100, 200, 255));
		JLabel[] scoreLabels = new JLabel[gameParameters.getNumberOfPlayers()];

		for (int i = 0; i < scoreLabels.length; i++) {
			scoreLabels[i] = new JLabel();
			scorePanel.add(scoreLabels[i]);
		}
		MessagePanel messagePanel = new MessagePanel();
		//        messagePanel.setBackground(Color.YELLOW);
		gamingArea = new GamingArea(mainPanel, gameParameters, scoreLabels, messagePanel);

		add(scorePanel, BorderLayout.NORTH);
		add(gamingArea, BorderLayout.CENTER);
		add(messagePanel, BorderLayout.SOUTH);
	}

	@Override
	public void requestFocus() {
		gamingArea.requestFocusInWindow();
	}
}
