/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.net.Client;
import com.serponix.net.Server;
import java.awt.Dimension;
import java.util.List;

/**
 * Contains all parametrs of game, which have to be chosen before runing the game.
 *
 * @author Daniel Vala
 */
public class GameParameters {

	private GameModeEnum mode;
	private int speed;
	private List<Player> players;
	private int numberOfPlayers;
	private Mapa map;
	private Server server;
	private Client client;
	private Dimension sizeOfGamingArea;

	public GameParameters(GameModeEnum mode, int speed, List<Player> players, Mapa map, Dimension sizeOfGamingArea, Server server) {
		this.mode = mode;
		this.speed = speed;
		this.players = players;
		this.numberOfPlayers = players.size();
		this.map = map;
		this.sizeOfGamingArea = sizeOfGamingArea;
		this.server = server;
	}

	public GameParameters(GameModeEnum mode, int numberOfPlayers, Mapa map, Dimension sizeOfGamingArea, Client client) {
		this.mode = mode;
		this.numberOfPlayers = numberOfPlayers;
		this.map = map;
		this.sizeOfGamingArea = sizeOfGamingArea;
		this.client = client;
	}

	public GameParameters(GameModeEnum mode) {
		this.mode = mode;
	}

	public Client getClient() {
		return client;
	}

	public List<Player> getPlayers() {
		return players;
	}

	public Mapa getMap() {
		return map;
	}

	public GameModeEnum getMode() {
		return mode;
	}

	public int getNumberOfPlayers() {
		return numberOfPlayers;
	}

	public int getSpeed() {
		return speed;
	}

	public Server getServer() {
		return server;
	}

	public Dimension getSizeOfGamingArea() {
		return sizeOfGamingArea;
	}
}
