/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.game.food.Cake;
import com.serponix.game.score.HighSkore;
import com.serponix.game.score.Score;
import com.serponix.gui.WindowInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

/**
 * Reprezentuje high-skore mód.
 *
 * @author Daniel Vala
 */
public class ModelRecord extends GameModel {

	public ModelRecord(WindowInterface okno, GameParameters parametryHry, GamingArea herniPanel, JLabel[] skoreStitky, MessagePanel panelZprav) {
		super(okno, parametryHry, herniPanel, skoreStitky, panelZprav, new Dimension(500, 500));
		hadi = new Snake[1];
		hadi[0] = new Snake(this, getHrac(0), 10, -1, Direction.DOWN, 10, getVelikostPolicka(), 10, 0, Color.BLUE, null, false, false);
		getHrac(0).init(this, hadi[0]);
		jidlo = new Cake(this);

		startHry();
	}

	/**
	 * Get score of the only player from his length.
	 * For one cell of snake gets 5 points except initial 10 cells (that is why minus 50)
	 * Score do not save to any variable to prevent hack it.
	 *
	 * @return Actual score of the only snake in the game.
	 */
	public int getScore() {
		return (hadi[0].getDelka() * 5) - 50;
	}

	/**
	 * Mód rekord zdi nepoužívá, metoda nic neudělá.
	 *
	 * @param g
	 */
	@Override
	void paintZdi(Graphics g) {
	}

	// v případě srážky hada hra končí
	@Override
	public void resetHada(Snake had) {
		JOptionPane.showMessageDialog(null, String.format("Dosáhl jste skore %d", getScore()), "KONEC HRY", JOptionPane.INFORMATION_MESSAGE);
		HighSkore.zapisSkore(getScore());
		HighSkore.zobrazSkore();
		ukonciHru();
	}

	@Override
	public void newRound() {
	}

	@Override
	public void jidloSezrano(Snake had) {
		jidlo.generateFood();
		had.prodluzHada();
	}

	@Override
	public void bonusSezran(Snake had) {
	}

	// metoda krok kontroluje jestli had nenarazil do steny, jestli had neji a jestli had nenarazil do druheho hada
	@Override
	public void krok() {
		getHrac(0).posunSe();
		setSkoreText(0, "Skore: " + getScore());
		setChanged();
		notifyObservers();
	}

	@Override
	public void paint(Graphics g) {
		if (!zobrazVeciNaPlose) {
			for (Snake had : hadi) {
				had.draw(g);
			}
			jidlo.draw(g);
		} else {
			zobrazVeciNaPlose(g);
		}
	}

	@Override
	public void addScore(Score skore, int body) {
	}
}
