/**
 * Serponix is an arcade game in focus to multiplayer based on the classic game
 * Snake. Copyright (C) 2010 - 2011 Daniel Vala
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * If you have any question do not hesitate to contact author on e-mail address:
 * danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.gui.MainPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/**
 * In this class is main method of the game. Creates
 * <code>JFrame</code>, which contains
 * <code>MainPanel</code> Minimum size of window is 900x600 pixels.
 *
 * @author Daniel Vala
 */
public class Run {

	public static void main(String[] args) {
		JFrame frame = new JFrame("Serponix");
		try {
			UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
		} catch (ClassNotFoundException ex) {
			System.err.println("Vzhled nebyl nalezen");
		} catch (InstantiationException ex) {
			System.err.println("Vzhled nebyl inicializován");
		} catch (IllegalAccessException ex) {
			System.err.println("Vzhled nebyl načten : Neplatný přístup");
		} catch (UnsupportedLookAndFeelException ex) {
			System.err.println("Vzhled nebyl načten: Není podporován operačním systémem");
		}
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		MainPanel mainPanel = new MainPanel();
		frame.add(mainPanel);

		// nastavení ikony hry
		Image icon = Toolkit.getDefaultToolkit().getImage(Panel.class.getResource("/images/snake.gif"));
		frame.setIconImage(icon);
		// can be replaced by following 2 lines in non static context to work in java webstart:
		//        ImageIcon icon = new ImageIcon(getClass().getResource("/images/snake.gif"));
		//        frame.setIconImage(icon.getImage());

		// nastavení velikosti okna
		frame.setMinimumSize(new Dimension(900, 600));
		frame.setSize(screen);
		frame.setExtendedState(Frame.MAXIMIZED_BOTH);

		// fullscreen
		//         frame.setUndecorated(true);

		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);

		//        GameSettings gameSettings = GameSettings.getInstance();
		//        gameSettings.load(); // throws java.security.AccessControlException in java web start
	}
}
