/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game.food;

import com.serponix.game.GameModel;
import com.serponix.game.objektyNaPlose.VecNaPolicku;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Random;

/**
 * Potravina obsahuje své souřadnice a obsahuje metodu pro vygenerování tj. přesunu sama sebe do náhodné polohy.
 *
 * @author Daniel Vala
 */
public abstract class Food extends VecNaPolicku {

	protected GameModel model;

	public Food(GameModel model) {
		this.model = model;
		generateFood();
	}

	public abstract Image getTextura();

	public abstract String getInstrukceProKresleni();

	public void generateFood() {
		vygenerujPotravinu(model.getSirkaLogicka(), model.getVyskaLogicka());
	}

	/**
	 * Vygeneruje náhodnou souřadnici od [0:0] do zadaných souřadnic, na kterou se přesune.
	 * Přesune se vždy na volné políčko.
	 *
	 * @param okrajX X okraj mapy, na kterou je možno přesunout jídlo.
	 * @param okrajY Y okraj mapy, na kterou je možno přesunout jídlo.
	 */
	public void vygenerujPotravinu(int okrajX, int okrajY) {
		odmapuj(model);
		Random generator = new Random();
		int newX;
		int newY;
		do {
			newX = generator.nextInt(okrajX);
			newY = generator.nextInt(okrajY);
		} while (model.getObjektNaHerniPlose(newX, newY) != null);
		move(newX, newY);
		namapuj(model);
	}

	public abstract void draw(Graphics g);
}
