/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game.objektyNaPlose;

import com.serponix.game.GameModel;
import java.io.Serializable;

/**
 * Věc na políčku reprezentuje objekt, který může být umístěn na herní plochu.
 * Každý objekt může zabírat pouze jedno políčko. Větší objekt musí být
 * složen z více těchto objektů.
 *
 * @author Daniel Vala
 */
public abstract class VecNaPolicku implements Serializable {

	public int x;
	public int y;

	public VecNaPolicku() {
	}

	public VecNaPolicku(int x, int y) {
		this.x = x;
		this.y = y;
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public void move(int x, int y) {
		this.x = x;
		this.y = y;
	}

	public void namapuj(GameModel model) {
		model.umistiVecNaHerniPlochu(this, getX(), getY());
	}

	public void odmapuj(GameModel model) {
		model.odstranVecNaHerniPlose(this);
	}
}
