/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game.projectiles;

import com.serponix.game.Direction;
import com.serponix.game.GameModel;
import com.serponix.game.Snake;
import com.serponix.game.objektyNaPlose.VecNaPolicku;
import java.awt.Graphics;
import java.awt.Point;

/**
 * Střela se umí posunout ve svém směru svojí rychlostí.
 * Obsahuje instrukce pro kreslení a kontrolu kolizí stěn.
 * Střelu lze také zničit.
 *
 * @author Daniel Vala
 */
public abstract class Projectile extends VecNaPolicku {

	protected GameModel model;
	protected Snake snake;
	protected Direction smer;
	protected int rychlost;

	public Projectile(GameModel model, Snake had, int x, int y, Direction smer, int rychlost) {
		super(x, y);
		this.model = model;
		this.snake = had;
		this.smer = smer;
		this.rychlost = rychlost;
	}

	/**
	 * Vrátí jméno hada, který vlastní tuto střelu.
	 *
	 * @return Jméno hada, který vlastní tuto střelu.
	 */
	public String getJmenoVlastnika() {
		return snake.getJmeno();
	}

	public abstract String getInstrukceProKresleni();

	protected abstract void znicSe();

	protected abstract boolean kolize(int x, int y);

	/**
	 * Posune střelu dle její rychlosti a směru, zkontroluje možnost nárazu.
	 *
	 * @return true, pokud střela posun přežila. False, pokud při něm byla zničena.
	 */
	public boolean posunSe() {
		for (int i = 0; i < rychlost; i++) {

			Point polickoPredStrelou = model.getPolickoPred(getX(), getY(), smer);

			if (kolize(polickoPredStrelou.x, polickoPredStrelou.y)) {
				return false;
			}

			odmapuj(model);
			move(polickoPredStrelou.x, polickoPredStrelou.y);
			namapuj(model);
		}
		return true;
	}

	public abstract void draw(Graphics g);
}
