/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Panel s informacemi o hře.
 *
 * @author Daniel Vala
 */
public class ViewAbout extends JPanel {

	/**
	 * Vytvoří panel s informacemi o hře.
	 *
	 * @param okno Okno, ve kterém se vytvoří JPanel.
	 */
	public ViewAbout(final MainPanel okno) {
		setLayout(new BorderLayout());
		String napoveda = "<html><h3>O hře Serponix:</h3>" +
				"Hra Serponix je arkádová hra vycházející ze hry Had známé z telefonů Nokia. <br />" +
				"Tuto hru rozšiřuje o množství zábavných prvků jako je možnost střelby či sbírání bonusových vlastností. <br />" +
				"Hra nabízí 5 různých módů se specifickými pravidly a možnost hry více hráčů. <br /><br />" +
				"Autor: Daniel Vála <br />" +
				"Web: www.serponix.com <br /><br />" +
				"<b>Poděkování: </b> <br />" +
				"Ing. Vladimírovi Klimešovi za jeho obdivuhodné znalosti Javy i jiné. <br />" +
				"Mému bratrovi Vladimíru Válovi za neustálé a kvalitní testování hry a nespočet nápadů na vylepšení. <br />" +
				"Další tester je můj spolužák Tomáš Šmejkal. <br />" +
				"Velký dík také patří Františkovi Petružálkovi za pomoc při implementačních problémech. <br />" +
				"Nesmím zapomenout poděkovat mým rodičům, kteří mě celý život podporují a díky kterým vznikl také handicap mód. <br />" +
				"Tester a rádce, který také ovlivnil hru je můj kamarád Martin Hobža. <br />" +
				"Nakonec musím zmínit také Martina Švece, který stojí za nápadem naprogramovat hada." + "<br /><br /><br /><br /><br /><br />" + "Serponix Copyright (C) 2014  Daniel Vála www.serponix.com <br /><br />" + "This program comes with ABSOLUTELY NO WARRANTY. <br />" + "This is free software, and you are welcome to redistribute it under certain conditions. <br />" + "</html>";
		JPanel panelTextu = new JPanel();
		panelTextu.add(new JLabel(napoveda));
		add(panelTextu, BorderLayout.NORTH);

		JPanel panelSTlacitkem = new JPanel();
		JButton menu = new JButton("zpět do menu");
		panelSTlacitkem.add(menu);
		add(panelSTlacitkem, BorderLayout.CENTER);

		menu.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				okno.displayMenu();
			}
		});

		addKeyListener(new KeyAdapter() {

			@Override
			public void keyPressed(KeyEvent event) {
				if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
					okno.displayMenu();
				}
			}
		});
	}
}
