/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Panel s nápovědou obsahuje informace o pravidlech všech módu hry a ovládání.
 *
 * @author Daniel Vala
 */
public class ViewHelp extends JPanel {

	/**
	 * Vytvoří panel nápovědy, do kterého přidá informace o pravidlech všech módu hry a ovládání.
	 *
	 * @param okno Okno, ve kterém se vytvoří JPanel.
	 */
	public ViewHelp(final MainPanel okno) {
		setLayout(new BorderLayout());
		String napoveda = "<html><h3>Hra Serponix obsahuje 5 módů hry:</h3>" + "<b>Mód classic:</b><br />" + "K vítězství je potřeba dosáhnout 500 bodů. Za každé sebrané jídlo hráč získá 50 bodů, za sebraný bonus 100 bodů. <br />" + "Při nárazu had 10 bodů ztratí.<br />" + "<b>Mód Tron:</b><br />" + "Had se neustále zvětšuje a vyhraje had, který přežije nejdéle.<br />" + "<b>Mód Record:</b><br />" + "Tento mód je pro jednoho hráče. Had se každým sežráním jídla zvětší o 10 jeho nových článků. <br />" + "Pokud narazí, nastává konec hry. Pokud hráč dosáhne dobrého výsledku, zapíše se jeho skóre do TOP 5.<br />" + "<b>Mód Handicap:</b><br />" + "Jedná se o klasický mód, jen je vše větší a pomalejší. Doporučuje se pro začínající hráče.<br />" + "<b>Fun mód:</b><br />" + "Cílem hry je dosáhnout velikosti 42 článků nebo eliminovat všechny protivníky. <br />" + "Bonus Vám dává speciální schopnosti, které však ale mohou být i negativní. <br />" + "K dispozici máte 2 druhy střeliva. Laser vždy a rakety po sebrání bonusu raket. <br />" + "Hadovi, který je již nebezpečně dlouhý a je potenciálním vítězem, bliká ocas.<br />" + "<br /><b>Ovládání hry:</b> <br /> Hada je možné ovládat směrovými šipkami do 4 světových stran. Může používat 2 různé zbraně mezerníkem a klávesou CTRL. Toto nastavení lze změnit. <br />" + "Klávesou P lze hru pozastavit. <br />" + "Klávesou F8 lze restartovat hru, pokud již hrají jen hadi ovládáni umělou inteligencí. <br />" + "Klávesou ESCAPE je možné hru ukončit.<br /><br />" +
				"<b> Další informace najdete na www.serponix.com </b>" +
				"</html>";
		JPanel panelTextu = new JPanel();
		panelTextu.add(new JLabel(napoveda));
		add(panelTextu, BorderLayout.NORTH);

		JPanel panelSTlacitkem = new JPanel();
		JButton menu = new JButton("zpět do menu");
		panelSTlacitkem.add(menu);
		add(panelSTlacitkem, BorderLayout.CENTER);

		menu.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				okno.displayMenu();
			}
		});

		addKeyListener(new KeyAdapter() {

			@Override
			public void keyPressed(KeyEvent event) {
				if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
					okno.displayMenu();
				}
			}
		});
	}
}
