/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.game.Player;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Controller pro comboBox, který obsahuje hráče.
 * Podle výběru provede příslušnou akci.
 *
 * @author Daniel Vala
 */
public class ControllerHraci implements ActionListener {

	private ModelLobbyServer model;
	private int cisloComboBoxu;

	public ControllerHraci(ModelLobbyServer model, int cisloComboBoxu) {
		this.model = model;
		this.cisloComboBoxu = cisloComboBoxu;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		model.getVybraniHraci().clear();
		for (ModelComboBoxHrace comboBoxModel : model.getModelyComboBoxuHracu()) {
			Object object = comboBoxModel.getSelectedItem();
			if (object != null && object instanceof Player) {
				Player hrac = (Player) object;
				model.getVybraniHraci().add(hrac);
			} else if (object != null && comboBoxModel.getSelectedItem().equals("VYHODIT")) {
				model.vyhodHrace(cisloComboBoxu);
				model.zobrazAPosliZpravu("Hráč " + comboBoxModel.getPredchoziHrac() + " byl vyhozen ze hry.");
			}
		}
		for (ModelComboBoxHrace c : model.getModelyComboBoxuHracu()) {
			c.vyberChaged();
		}
	}
}
