/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.game.GameModeEnum;
import com.serponix.game.GameParameters;
import com.serponix.game.Player;
import com.serponix.gui.MainPanel;
import com.serponix.settings.GameSettings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JOptionPane;

/**
 * Controller, který odstartuje hru.
 * Tento controller slouží pouze pro server.
 * Při startu se nastaví všechny parametry hry podle nastavení v lobby.
 *
 * @author Daniel Vala
 */
public class ControllerStartHry implements ActionListener {

	private ModelLobbyServer model;
	private ViewLobby view;
	private MainPanel okno;

	public ControllerStartHry(ModelLobbyServer model, ViewLobby view, MainPanel okno) {
		this.model = model;
		this.view = view;
		this.okno = okno;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		int pocetAI = 0;
		for (ModelComboBoxHrace mch : model.getModelyComboBoxuHracu()) {
			if (mch.getSelectedItem().equals("AI_STANDARD")) {
				pocetAI++;
			}
		}
		Dimension velikostHerniPlochy = view.getVelikostHerniPlochy();

		if (!model.getMapa().getNazev().equals("prázdná mapa")) {
			if (model.getGameMode() == GameModeEnum.HANDICAP) {
				JOptionPane.showMessageDialog(okno, "V módu handicap nelze používat mapy.", "Informace", JOptionPane.INFORMATION_MESSAGE);
				return;
			}
			if (velikostHerniPlochy.width != 1100 || velikostHerniPlochy.height != 600) {
				JOptionPane.showMessageDialog(okno, "Tato mapa je vytvořena pro rozměr 1100x600.", "Informace", JOptionPane.INFORMATION_MESSAGE);
				velikostHerniPlochy.width = 1100;
				velikostHerniPlochy.height = 600;
			}
		}
		GameSettings.getInstance().setGameMode(model.getGameMode());
		if (model.getGameMode() == GameModeEnum.HANDICAP) {
			velikostHerniPlochy = new Dimension(300, 150);
			model.setGameMode(GameModeEnum.CLASSIC_SNAKE);
		}

		double soucetVelikostiHerniPlochy = velikostHerniPlochy.getWidth() + velikostHerniPlochy.getHeight();
		int zaklad = 1700;
		double pomer = zaklad / soucetVelikostiHerniPlochy;

		int rychlostHry = 120 - model.getRychlostHry();

		// uzpůsobení rychlosti hry velikosti herní plochy
		rychlostHry *= pomer;

		if (model.getGameMode() == GameModeEnum.TRON) {
			if (pocetAI > 0) {
				JOptionPane.showMessageDialog(okno, "Mód TRON nelze hrát s umělou inteligencí.", "Chyba", JOptionPane.ERROR_MESSAGE);
				return;
			}
			if (model.getVybraniHraci().size() < 2) {
				JOptionPane.showMessageDialog(okno, "Mód TRON lze hrát minimálně ve 2 hráčích.", "Chyba", JOptionPane.ERROR_MESSAGE);
				return;
			}
			if (model.isClientPlaying()) {
				JOptionPane.showMessageDialog(okno, "Mód TRON nelze hrát po síti.", "Chyba", JOptionPane.ERROR_MESSAGE);
				return;
			}
		}

		List<Player> vybraniHraci = model.getVybraniHraci();
		for (int i = 0; i < pocetAI; i++) {
			vybraniHraci.add(new Player("AI " + (i + 1), Player.Control.AI_STANDARD, null));
		}

		GameSettings gameSettings = GameSettings.getInstance();
		gameSettings.setSpeed(model.getRychlostHry());
		gameSettings.save();

		GameParameters parametryHry = new GameParameters(model.getGameMode(), rychlostHry, model.getVybraniHraci(), model.getMapa(), velikostHerniPlochy, model.getServer());
		okno.displayGame(parametryHry);
		model.getServer().odstartujHru(model.getVybraniHraci().size(), velikostHerniPlochy, model.getMapa());
	}
}
