/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.game.Player;
import com.serponix.net.Informace;
import com.serponix.net.Server;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

/**
 * Model obsluhuje všechnu logiku pro možný výběr v comboBoxu,
 * co se má za jakých podmínek zobrazit a posílání informací při změně.
 *
 * @author Daniel Vala
 */
public class ModelComboBoxHrace extends AbstractListModel implements ComboBoxModel {

	private List<Player> hraci;
	private List<Player> vybrani;
	private Object selectedItem;
	private Player predchoziHrac;
	private int cisloHrace;
	private Server server;

	public ModelComboBoxHrace(ModelLobbyServer modelLobby, int cisloHrace, Server server) {
		hraci = modelLobby.getHraci();
		vybrani = modelLobby.getVybraniHraci();
		selectedItem = "OTEVŘENO";
		this.cisloHrace = cisloHrace;
		this.server = server;
	}

	public void posliStav() {
		server.poslatData(Informace.HRAC + Informace.ODDELOVAC1 + cisloHrace + Informace.ODDELOVAC3 + selectedItem);
	}

	public void posliStavKlientovi(DatagramPacket packet) {
		server.posliDataKlientovi(Informace.HRAC + Informace.ODDELOVAC1 + cisloHrace + Informace.ODDELOVAC3 + selectedItem, packet);
	}

	public Player getPredchoziHrac() {
		return predchoziHrac;
	}

	/**
	 * Vrátí všechny hráče, kteří se zobrazí v comboBoxu.
	 *
	 * @return Pole hráčů, kteří se zobrazí v comboBoxu.
	 */
	private List<Player> getHraciProZobrazeni() {
		List<Player> pom = new ArrayList<Player>(vybrani);
		if (selectedItem instanceof Player) {
			pom.remove((Player) selectedItem);
		}
		List<Player> retval = new ArrayList<Player>(hraci);
		retval.removeAll(pom);
		return retval;
	}

	@Override
	public int getSize() {
		if (getSelectedItem() instanceof Player && ((Player) getSelectedItem()).getOvladani() == Player.Control.CLIENT) {
			return 1;
		}
		return 3 + getHraciProZobrazeni().size();
	}

	@Override
	public Object getElementAt(int index) {
		if (getSelectedItem() instanceof Player && ((Player) getSelectedItem()).getOvladani() == Player.Control.CLIENT) {
			predchoziHrac = (Player) getSelectedItem();
			return "VYHODIT";
		} else if (index == 0) {
			return "OTEVŘENO";
		} else if (index == 1) {
			return "ZAVŘENO";
		} else if (index == 2) {
			return "AI_STANDARD";
		}
		return getHraciProZobrazeni().get(index - 3);
	}

	public void vyberChaged() {
		fireContentsChanged(this, 3, getSize());
	}

	@Override
	public void setSelectedItem(Object anItem) {
		selectedItem = anItem;
		posliStav();
	}

	@Override
	public Object getSelectedItem() {
		return selectedItem;
	}
}
