/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.game.GameModeEnum;
import com.serponix.game.GameParameters;
import com.serponix.game.Mapa;
import com.serponix.gui.MainPanel;
import com.serponix.net.Client;
import java.awt.Dimension;
import java.net.InetAddress;

/**
 * Model lobby pro klienta rozšiřuje model
 * o parametry a metody specifické pro klienta.
 *
 * @author Daniel Vala
 */
public class ModelLobbyClient extends ModelLobby {

	private Client client;
	private MainPanel mainPanel;
	private String[] hraci;

	public ModelLobbyClient(MainPanel okno, Client client) {
		super(okno);
		this.mainPanel = okno;
		setNet(client);
		this.client = client;
		client.setLobby(this);
		hraci = new String[10];

		new Thread(client).start();
	}

	public void startHry(int pocetHracu, Dimension velikostHerniPlochy, Mapa mapa) {
		GameParameters parametryHry = new GameParameters(GameModeEnum.CLIENT, pocetHracu, mapa, velikostHerniPlochy, client);
		mainPanel.displayGame(parametryHry);
	}

	/**
	 * Sets the game mode to client GUI.
	 *
	 * @param gameMode Game mode.
	 */
	@Override
	public void setGameMode(GameModeEnum gameMode) {
		super.setGameMode(gameMode);
		setChanged();
		LobbyEvent evt = LobbyEvent.MOD_HRY;
		evt.data = gameMode.toString();
		notifyObservers(evt);
	}

	public void setStitekMapy(String nazevMapy) {
		setNazevMapy(nazevMapy);
		setChanged();
		LobbyEvent evt = LobbyEvent.MAPA;
		evt.data = nazevMapy;
		notifyObservers(evt);
	}

	public void setRychlostHry(String rychlost) {
		setRychlostHry(Integer.parseInt(rychlost));
		setChanged();
		LobbyEvent evt = LobbyEvent.RYCHLOST;
		evt.data = rychlost;
		notifyObservers(evt);
	}

	public void setHrac(int cisloHrace, String jmeno) {
		hraci[cisloHrace] = jmeno;
		setChanged();
		LobbyEvent evt = LobbyEvent.HRAC;
		evt.cislo = cisloHrace;
		evt.data = jmeno;
		notifyObservers(evt);
	}

	public String getHrac(int cisloHrace) {
		return hraci[cisloHrace];
	}

	public InetAddress getServerIP() {
		return client.getServerIP();
	}
}
