/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.gui.MainPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import javax.swing.*;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

/**
 * View obsahuje společné komponenty GUI pro lobby.
 *
 * @author Daniel Vala
 */
public abstract class ViewLobby extends JPanel implements Observer {

	protected ModelLobby modelLobby;
	protected JPanel panel, nadpis, panelHracu, centralniPanel, dolniPanel, panelNastaveni, panelZprav, panelIP, panelStartExit;
	protected JLabel stitekNadpis, stitekRychlost, nastaveni, stitekNazevMapy;
	protected JSlider sliderRychlostHry;
	protected JComboBox[] comboBoxyVyberHrace;
	protected JComboBox comboBoxModHry;
	protected JTextField textFieldZpravy;
	protected JTextArea chatArea;
	protected JScrollPane chatScrollPane;
	protected JButton odeslat, exit;
	protected JSpinner spinnerSirka, spinnerVyska;
	protected SpinnerNumberModel spinnerModelSirka, spinnerModelVyska;

	public ViewLobby(ModelLobby modelLobby, MainPanel okno) {
		this.modelLobby = modelLobby;
		////// TVORBA PANELŮ //////
		panel = new JPanel(new BorderLayout(50, 50));
		nadpis = new JPanel();
		panelHracu = new JPanel();
		panelHracu.setLayout(new BoxLayout(panelHracu, BoxLayout.PAGE_AXIS));
		centralniPanel = new JPanel();
		panelNastaveni = new JPanel();
		panelNastaveni.setLayout(new BoxLayout(panelNastaveni, BoxLayout.PAGE_AXIS));
		dolniPanel = new JPanel(new BorderLayout());
		panelZprav = new JPanel();
		panelIP = new JPanel();
		panelStartExit = new JPanel();

		/////      NADPIS     /////
		stitekNadpis = new JLabel("Serponix");
		stitekNadpis.setFont(new Font("font1", Font.BOLD, 40));
		nadpis.add(stitekNadpis);

		///// CENTRALNI PANEL /////
		chatArea = new JTextArea(10, 30);
		chatArea.setEditable(false);
		chatArea.setLineWrap(true);
		chatArea.setWrapStyleWord(true);

		chatScrollPane = new JScrollPane(chatArea);
		chatScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

		centralniPanel.add(chatScrollPane);

		/////// PANEL HRAČŮ ///////
		comboBoxyVyberHrace = new JComboBox[10];
		for (int i = 0; i < comboBoxyVyberHrace.length; i++) {
			comboBoxyVyberHrace[i] = new JComboBox();
			panelHracu.add(comboBoxyVyberHrace[i]);
		}

		///// PANEL NASTAVENÍ /////
		nastaveni = new JLabel("NASTAVENÍ HRY:");
		panelNastaveni.add(nastaveni);
		stitekRychlost = new JLabel("rychlost hry");
		panelNastaveni.add(stitekRychlost);
		sliderRychlostHry = new JSlider(0, 100, modelLobby.getRychlostHry());
		sliderRychlostHry.setMinorTickSpacing(20);
		sliderRychlostHry.setMajorTickSpacing(20);
		sliderRychlostHry.setPaintLabels(true);
		sliderRychlostHry.setPaintTicks(true);
		panelNastaveni.add(sliderRychlostHry);
		panelNastaveni.add(new JLabel("<html><br /></html>"));
		stitekNazevMapy = new JLabel(modelLobby.getNazevMapy());
		panelNastaveni.add(stitekNazevMapy);
		comboBoxModHry = new JComboBox();
		comboBoxModHry.setMinimumSize(new Dimension(115, 26));
		comboBoxModHry.setMaximumSize(new Dimension(115, 26));
		panelNastaveni.add(comboBoxModHry);

		spinnerModelSirka = new SpinnerNumberModel(1100, 300, 4000, 10);
		spinnerSirka = new JSpinner(spinnerModelSirka);
		spinnerSirka.setMinimumSize(new Dimension(115, 26));
		spinnerSirka.setMaximumSize(new Dimension(115, 26));

		panelNastaveni.add(spinnerSirka);

		spinnerModelVyska = new SpinnerNumberModel(600, 150, 2000, 10);
		spinnerVyska = new JSpinner(spinnerModelVyska);
		spinnerVyska.setMinimumSize(new Dimension(115, 26));
		spinnerVyska.setMaximumSize(new Dimension(115, 26));
		panelNastaveni.add(spinnerVyska);

		////// PANEL ZPRÁV ////////
		textFieldZpravy = new JTextField(20);
		panelZprav.add(textFieldZpravy);

		odeslat = new JButton("odeslat");
		panelZprav.add(odeslat);

		exit = new JButton("exit");
		panelStartExit.add(exit);

		dolniPanel.add(panelZprav, BorderLayout.NORTH);
		dolniPanel.add(panelIP, BorderLayout.CENTER);
		dolniPanel.add(panelStartExit, BorderLayout.SOUTH);

		///// PŘIDÁNÍ PANELŮ /////
		panel.add(nadpis, BorderLayout.NORTH);
		panel.add(panelHracu, BorderLayout.WEST);
		panel.add(centralniPanel, BorderLayout.CENTER);
		panel.add(panelNastaveni, BorderLayout.EAST);
		panel.add(dolniPanel, BorderLayout.SOUTH);
		add(panel);

		textFieldZpravy.addActionListener(new ControllerZpravy(modelLobby, null));
		odeslat.addActionListener(new ControllerZpravy(modelLobby, textFieldZpravy));
	}

	public Dimension getVelikostHerniPlochy() {
		return new Dimension((Integer) spinnerSirka.getValue(), (Integer) spinnerVyska.getValue());
	}

	public abstract void update(Observable o, Object arg);

	/**
	 * Zobrazí zadanou zprávu v chatArea.
	 *
	 * @param zprava Nová zpráva, která se zobrazí v chatArea.
	 *               Null a prázdný string se ignoruje
	 */
	protected void zobrazInformaci(String zprava) {
		if (zprava == null || zprava.equals("")) {
			return;
		}
		Document d = chatArea.getDocument();
		JScrollBar scrollBar = chatScrollPane.getVerticalScrollBar();
		try {
			// pokud už chatArea obsahuje text, zalomí se řádek pro nový text
			if (!d.getText(0, d.getLength()).equals("")) {
				chatArea.append("\n");
			}
			chatArea.append(zprava);

			boolean autoScroll = false;
			if (scrollBar.getMaximum() - (scrollBar.getValue() + scrollBar.getVisibleAmount()) <= 10) {
				autoScroll = true;
			}

			// pokud je posuvník dole, skroluje se automaticky dolu, jinak se nechává na stejném místě
			if (autoScroll) {
				chatArea.setCaretPosition(chatArea.getText().length());
			} else {
				chatArea.setCaretPosition(scrollBar.getValue());
			}
		} catch (BadLocationException ex) {
			JOptionPane.showMessageDialog(this, " Údaje pro opravu chyby: BadLocationException ve třídě ViewLobby.\n" + "value + visible amount = " + (scrollBar.getValue() + scrollBar.getVisibleAmount()) + " maximum scrollbaru = " + scrollBar.getMaximum(), "Chyba posouvátka", JOptionPane.ERROR_MESSAGE);
		} catch (IllegalArgumentException ex) {
			System.err.println("IllegalArgumentExceptionException");
		}
	}

	/**
	 * Nastaví tlačítko odeslat jako defaultní tlačítko lobby.
	 */
	public void setDefaultButton() {
		getRootPane().setDefaultButton(odeslat);
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		setDefaultButton();
	}
}
