/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.game.GameModeEnum;
import com.serponix.gui.MainPanel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JLabel;

/**
 * View pro server obsahuje komponenty GUI specifické pro server.
 *
 * @author Daniel Vala
 */
public class ViewLobbyServer extends ViewLobby {

	private JLabel stitekIP;
	private JButton start, nactiMapu;

	public ViewLobbyServer(ModelLobbyServer modelLobbyServer, MainPanel okno) {
		super(modelLobbyServer, okno);

		stitekNadpis.setText("Serponix - založená hra");

		for (int i = 0; i < comboBoxyVyberHrace.length; i++) {
			comboBoxyVyberHrace[i].setModel(modelLobbyServer.createAndReturnModelComboBoxHrace(i));
			comboBoxyVyberHrace[i].addActionListener(new ControllerHraci(modelLobbyServer, i));
		}
		comboBoxyVyberHrace[0].setSelectedItem(modelLobbyServer.getHraci().get(0));
		comboBoxyVyberHrace[1].setSelectedItem("AI_STANDARD");
		nactiMapu = new JButton("Načti mapu");
		panelNastaveni.add(nactiMapu, panelNastaveni.getComponentCount() - 5);
		comboBoxModHry.addItem(GameModeEnum.CLASSIC_SNAKE);
		comboBoxModHry.addItem(GameModeEnum.TRON);
		comboBoxModHry.addItem(GameModeEnum.HANDICAP);
		comboBoxModHry.addItem(GameModeEnum.FUN_MOD);
		comboBoxModHry.setSelectedItem(modelLobbyServer.getGameMode());

		panelNastaveni.add(new JLabel("šířka herní plochy"), panelNastaveni.getComponentCount() - 2);
		panelNastaveni.add(new JLabel("výška herní plochy"), panelNastaveni.getComponentCount() - 1);
		spinnerSirka.addChangeListener(new ControllerVelikostPlochy(spinnerModelSirka));
		spinnerVyska.addChangeListener(new ControllerVelikostPlochy(spinnerModelVyska));

		try {
			stitekIP = new JLabel(InetAddress.getLocalHost().toString());
		} catch (UnknownHostException ex) {
			stitekIP = new JLabel("Neznámá IP adresa.");
		}
		panelIP.add(stitekIP);

		start = new JButton("start");
		panelStartExit.add(start);
		exit.addActionListener(new ControllerExit(modelLobby, this));
		exit.setText("zrušit hru");

		modelLobby.addObserver(this);

		start.addActionListener(new ControllerStartHry(modelLobbyServer, this, okno));
		comboBoxModHry.addItemListener(new ControllerModHry(modelLobbyServer));
		nactiMapu.addActionListener(new ControllerNactiMapu(modelLobbyServer, stitekNazevMapy));
		sliderRychlostHry.addChangeListener(new ControllerRychlostHry(modelLobbyServer));
	}

	@Override
	public void update(Observable o, Object arg) {
		if (arg instanceof LobbyEvent) {
			LobbyEvent evt = (LobbyEvent) arg;
			switch (evt) {
				case ZPRAVA:
					zobrazInformaci(evt.data);
					break;
				case ZPRAVA_A_VYMAZ:
					zobrazInformaci(evt.data);
					textFieldZpravy.setText("");
					textFieldZpravy.requestFocus();
					break;
			}
		} else {
			throw new IllegalArgumentException(arg.getClass().getName() + " není typu LobbyEvent.");
		}
	}
}
