/**
 * Serponix is an arcade game in focus to multiplayer based on the classic game
 * Snake. Copyright (C) 2010 - 2011 Daniel Vala
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * If you have any question do not hesitate to contact author on e-mail address:
 * danielvala42@gmail.com
 */
package com.serponix.gui.settings;

import com.serponix.gui.MainPanel;
import com.serponix.settings.GameSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

/**
 * Controller pro uložení aktuálního nastavení do souboru. Po uložení zobrazí
 * hlavní menu.
 *
 * @author Daniel Vala
 */
public class ControllerSave implements ActionListener {

	private ModelNastaveni model;
	private ViewNastaveni view;
	private MainPanel okno;

	public ControllerSave(ModelNastaveni model, ViewNastaveni view, MainPanel okno) {
		this.model = model;
		this.view = view;
		this.okno = okno;
	}

	public void actionPerformed(ActionEvent e) {
		GameSettings gameSettings = GameSettings.getInstance();
		if (view.getPort() != gameSettings.getPort()) {

			if (view.getPort() <= 1024) {
				int vyber = JOptionPane.showConfirmDialog(okno, "Port v rozsahu 1 až 1024 je vyhrazen pro systémové aplikace." + "\n Některé aplikace nemusí správně pracovat ve chvíli, kdy budete hrát." + "\n Chcete ponechat nastavený port " + view.getPort() + "?", "Upozornění", JOptionPane.WARNING_MESSAGE, JOptionPane.YES_NO_OPTION);
				if (vyber != 0) {
					return;
				}
			}
			gameSettings.setPort(view.getPort());
		}

		gameSettings.setAllKeys(model.getAllKeys());
		for (int i = 0; i < GameSettings.NUMBER_OF_HUMAN_PLAYERS; i++) {
			gameSettings.setNameOfGivenPlayer(i, view.getTextFieldJmeno(i));
		}
		gameSettings.setNumberOfActivePlayers(view.getPocetHracu());

		gameSettings.save();
		okno.displayMenu();
	}
}
