/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.settings;

import com.serponix.settings.SnakeAction;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;

/**
 * Controller pro nastavení možné akce daného hráče na konkrétní klávesu.
 *
 * @author Daniel Vala
 */
public class KeyController extends KeyAdapter {

	private ModelNastaveni model;
	private JButton button;
	private int hrac;
	private SnakeAction klavesa;

	public KeyController(ModelNastaveni model, JButton button, int hrac, SnakeAction klavesa) {
		this.model = model;
		this.button = button;
		this.hrac = hrac;
		this.klavesa = klavesa;
	}

	@Override
	public void keyPressed(KeyEvent event) {
		int key = event.getKeyCode();
		button.setText(KeyEvent.getKeyText(key));
		model.setKey(hrac, klavesa, key);
	}
}
