/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.net;

import com.serponix.game.ModelClient;
import com.serponix.gui.lobby.ModelLobbyClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.List;

/**
 * Klient rozšiřuje metody o nastavení lobby, modelu, získání IP adresy serveru,
 * příjem stavu lobby, příjem dat, vyhledávání her a připojení se k serveru.
 *
 * @author Daniel Vala
 */
public interface Client extends Net {

	void setLobby(ModelLobbyClient modelLobbyClient);

	void setModel(ModelClient model);

	InetAddress getServerIP();

	void prijemStavuLobby();

	void prijemDat();

	List<InetAddress> vyhledatHry() throws IOException;

	boolean pripojitSeKServeru(InetAddress serverIP) throws SocketTimeoutException, IOException;

	@Override
	void poslatData(String dataKPoslani);

	@Override
	void odpojSe();
}
