/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.net;

/**
 * Informace, které mohou být poslány po síti jako číslo.
 * Příklad poslání políčka klientům obecně a s konkrétním příkladem:
 * POLICKO#typ,x,y,barva,informace,smer,neviditelnost@typ,x,y,barva,informace,smer,neviditelnost
 * POLICKO#HAD,30,30,-16711936,CLANEK,NIC,NEVIDITELNOST@HAD,30,40,-16711936,HLAVA,DOLU,NEVIDITELNOST
 *
 * @author Daniel Vala
 */
public class Informace {

	/**
	 * určení, jaká zpráva bude následovat <br />
	 * oddělovač používá znak #
	 */
	public static final String ODDELOVAC1 = "#";

	/**
	 * rozdělení zpráv, za tímto oddělovačem bude následovat zpráva stejného typu <br />
	 * oddělovač používá znak @
	 */
	public static final String ODDELOVAC2 = "@";
	/**
	 * oddělení jednotlivých parametrů zprávy <br />
	 * oddělovač používá znak čárky ,
	 */
	public static final String ODDELOVAC3 = ",";

	// možnosti prvního oddělovače
	public static final int POLICKO = 1;
	public static final int SKORE = 2;
	public static final int INFO = 3;
	public static final int KROK = 4;

	// možnosti políčka
	public static final int HAD = 10;
	public static final int LASER = 11;
	public static final int RAKETA = 12;
	public static final int JIDLO = 13;
	public static final int BONUS = 14;
	public static final int SMAZ_ZED = 51;

	// informace políčka hada
	public static final int CLANEK = 20;
	public static final int ODOLNOST = 21;
	public static final int DUCH = 22;
	public static final int HLAVA = 23;
	public static final int HLAVA_TANKU = 24;

	// poslední volitelný parametr políčka
	public static final int NEVIDITELNOST = 30;

	// možnost neposlání např. žádné informace, pokud je potřeba poslat směr nebo neviditelnost
	public static final int NIC = 0;

	// další možnosti prvního oddělovače
	// směry pro příkazy pohybu serveru nebo klientovi o natočení hada
	public static final int NAHORU = 100;
	public static final int DOLU = 101;
	public static final int VLEVO = 102;
	public static final int VPRAVO = 103;

	// další příkazy serveru od klienta
	public static final int STREL = 104;
	public static final int STRELR = 105;
	public static final int PAUZA = 106;

	// zpráva klientovi, o konci hry následuje zprávou o vítězství
	public static final int VITEZSTVI = 108;

	// lobby
	// možnosti prvního oddělovače
	public static final int START = 150;
	public static final int ZPRAVA = 151;
	public static final int HRAC = 152;
	public static final int NAZEV_MAPY = 153;
	public static final int GAME_MODE = 154;
	public static final int RYCHLOST = 155;
	public static final int KONEC = 107;
	public static final int NOVY_HRAC = 170;
	public static final int HLEDANI = 171;

	public static final int VYHODIT = 156;
	public static final int PLNY_SERVER = 172;
	public static final int PRIJEM = 157;

	// možnosti startu
	public static final int POCET_HRACU = 160;
	public static final int VELIKOST_HERNI_PLOCHY = 161;
	public static final int MAPA = 162;
}
