/* 
 *  @author -- Lateef Yusuf
 *  @email -- iamlateef@gatech.edu
 *  @date -- Jul 21, 2010 
 */
// Sensor Service

package com.simplegdatamaps;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;

import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.provider.Settings;
 
public class LocationConnection implements LocationListener
{	
	private Activity mActivity;
	public LocationConnection(Activity activity)
	{
		mActivity = activity;
		locationManager = (LocationManager) mActivity.getSystemService(Context.LOCATION_SERVICE);
	}
	
	public boolean isProviderGPS() {
        return (bestProvider.equals(LocationManager.GPS_PROVIDER));
	}
	
	public boolean isGPSEnabled() {
		return locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
	}
 
	public void enableGPS() {
		if(!isGPSEnabled()) {
			Intent i = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
			mActivity.startActivity(i);
		}
	}
	
	public void setProviderGPS() {
		locationManager.removeUpdates(this);
		bestProvider = LocationManager.GPS_PROVIDER;
		locationManager.requestLocationUpdates(bestProvider, Constants.GPS_UPDATE_FREQUENCY,
				Constants.GPS_UPDATE_DISTANCE, this);
	}
	
	public void connect() 
	{
		Criteria criteria = new Criteria();
        bestProvider = locationManager.getBestProvider(criteria, true);
		locationManager.requestLocationUpdates(bestProvider, Constants.GPS_UPDATE_FREQUENCY,
				Constants.GPS_UPDATE_DISTANCE, this);
		lastKnownLocation = locationManager.getLastKnownLocation(bestProvider);
	}

	public void disconnect() 
	{
		locationManager.removeUpdates(this);
	}
	

	public Location lastKnownLocation() {
		return lastKnownLocation;
	}
	public void onLocationChanged(Location location) {
		 lastKnownLocation = location;
	}
		
	LocationManager locationManager;
	String bestProvider;
	private Location lastKnownLocation;

	public void onProviderDisabled(String provider) {
	}

	public void onProviderEnabled(String provider) {
		
	}

	public void onStatusChanged(String provider, int status, Bundle extras) {		
	}
}


