package uk.co.mattroper.simplesvnlogviewer;

import com.sun.star.uno.XComponentContext;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.container.XIndexAccess;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.XCell;

import ooo.connector.BootstrapSocketConnector;

import com.sun.star.sheet.XSpreadsheetDocument;

/**
 *
 * @author Matthew Roper
 */
public class OpenOfficeSpreadsheet {

    private XSpreadsheet xSpreadsheet = null;
    
    public OpenOfficeSpreadsheet ()
    {
        // Create a new empty spreadsheet
        XComponentContext xContext = null;
        
        try {
            // get the remote office component context
            String oooExeFolder = "/usr/bin/";
            xContext = BootstrapSocketConnector.bootstrap(oooExeFolder);
        } catch (java.lang.Exception e) {
            e.printStackTrace();
        }
        
        // get OO desktop
	XMultiComponentFactory xRemoteServiceManager = 
                xContext.getServiceManager();
        
        Object desktop = null;
        
	try {
            desktop = xRemoteServiceManager.createInstanceWithContext(
                "com.sun.star.frame.Desktop", xContext);
	} catch (Exception e) {}
        
        XComponentLoader xComponentLoader = (XComponentLoader)
        UnoRuntime.queryInterface(XComponentLoader.class, desktop);
        
        // Create a new empty spreadsheet
        PropertyValue[] loadProps = new PropertyValue[0];
        XComponent xCalcComponent = null;
        
        try {
            xCalcComponent = xComponentLoader.loadComponentFromURL(
                    "private:factory/scalc", "_blank", 0, loadProps);
        } catch (Exception e) {}

        XSpreadsheetDocument xSpreadsheetDocument = 
                (XSpreadsheetDocument) UnoRuntime.queryInterface(
                XSpreadsheetDocument.class, xCalcComponent);
        
        // Get the sheet we will output to
        Object sheets = xSpreadsheetDocument.getSheets();
        XIndexAccess xIndexedSheets = (XIndexAccess) UnoRuntime.queryInterface(
                XIndexAccess.class, sheets);
        Object sheet = null;
        try {
            sheet = xIndexedSheets.getByIndex(0);
        } catch (Exception e) {}
        XSpreadsheet xSpreadSheet = (XSpreadsheet) UnoRuntime.queryInterface(
                XSpreadsheet.class, sheet);

        this.xSpreadsheet = xSpreadSheet;
    }
    
    public void setCellValue(int arg1, int arg2, String arg3) throws Exception
    {
        // get the cell
        XCell xCell = this.xSpreadsheet.getCellByPosition(arg1, arg2);
        
        // get a text writing object
        com.sun.star.text.XText xText = (com.sun.star.text.XText)
                UnoRuntime.queryInterface(com.sun.star.text.XText.class, xCell);
        com.sun.star.text.XTextCursor xTextCursor = xText.createTextCursor();
        
        // insert the string
        xText.insertString(xTextCursor, arg3, false);
    }
}

