package org.simplextensions.maven.simpleextensions.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.simplextensions.maven.simpleextensions.plugin.jaxb.ExtensionsConfiguration;
import org.simplextensions.maven.simpleextensions.plugin.jaxb.JaxbUtil;

/**
 * Generate
 * 
 * @goal generate-extensions.xml
 * 
 * @phase prepare-package
 */
public class ExtensionsFileGenerator extends AbstractMojo {
	private static final String CLASSES_DIR = "classes";
	private static final String EXTENSIONS_XML_FILE = "extensions.xml";

	/** @parameter default-value="${project}" */
	private org.apache.maven.project.MavenProject mavenProject;

	/**
	 * @parameter expression ="${project.build.directory}"
	 * @required
	 */
	private String buildDirectory;

	public void execute() throws MojoExecutionException {
		File extensionsXml = new File(buildDirectory + File.separator + CLASSES_DIR + File.separator + EXTENSIONS_XML_FILE);
		ExtensionsConfiguration extensionsConfiguration = JaxbUtil.readConfiguration(extensionsXml);

		extensionsConfiguration.getClassNames().getClassName().addAll(getClassNames());

		JaxbUtil.saveConfiguration(extensionsConfiguration, extensionsXml);
	}

	private List<String> getClassNames() {
		// TODO to implement
		return Arrays.asList("org.simpleextensions.FooService", "org.simpleextensions.AntorherFooService");
	}
}
