package org.simplextensions.di;

import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;
import org.simplextensions.Simplextensions;
import org.simplextensions.di.annotations.ServiceDependency;
import org.simplextensions.registry.IDependencyLocatorRegistry;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.phaselisteners.IDependencyLocator;

public class DependencyLocatorTest {

	private IDependencyLocatorRegistry dependencyLocatorRegistry;

	@Before
	public void setUp() {

		IExtensionRegistry er = Simplextensions.createNewRegistry();
		dependencyLocatorRegistry = (IDependencyLocatorRegistry) er.getExtensionPointMD(IDependencyLocator.EP_ID).getExecutable();

	}

	@Test
	public void searchTest() {
		IDependencyLocator dependencyLocator = dependencyLocatorRegistry.findDependencyLocator(ServiceDependency.class);

		assertNotNull(dependencyLocator);
	}
}
