package org.simplextensions.registry;

/**
 * 
 * 
 * 
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-29 21:57:54
 * 
 */
public interface IServiceRegistry extends IExtensionPoint {

	/**
	 * find service implementing given interface. if found and not initialized
	 * then initialize it and start. when start() finishes and service is still
	 * not started (some error occured) then return null. next attemp to start
	 * this service will occur next time getService() is called
	 * 
	 * 
	 * @param <T>service interface
	 * @param clazz
	 *            service interface
	 * @return service if found, initialized and started
	 */
	<T> T getService(Class<T> clazz);

}