package org.simplextensions.di;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.IFooService;
import org.simplextensions.di.annotations.Point;
import org.simplextensions.di.annotations.Registry;
import org.simplextensions.di.annotations.ServiceDependency;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.IServiceRegistry;

import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class TestDependencyInjection {

	public class DependencyTestClass {

		@Registry
		private IExtensionRegistry extensionRegistry;

		@Point
		private IServiceRegistry serviceRegistry;

		@ServiceDependency
		private IFooService fooService;
	}

	private IExtensionRegistry er;
	private IServiceRegistry sr;
	private IFooService fs;

	@Before
	public void before() {
		er = mock(IExtensionRegistry.class);
		sr = mock(IServiceRegistry.class);
		fs = mock(IFooService.class);

		when(er.getExtensionPoint(eq(IServiceRegistry.class))).thenReturn(sr);
		when(sr.getService(eq(IFooService.class))).thenReturn(fs);
	}

	@Test
	public void test1() {

		DependencyTestClass targetObject = new DependencyTestClass();

		DependencyInjector.resolveDependency(er, targetObject);

		assertNotNull(targetObject.extensionRegistry);
		assertNotNull(targetObject.fooService);
		assertNotNull(targetObject.serviceRegistry);

	}

	@Test(expected = NullPointerException.class)
	public void testNullPoints() {
		DependencyInjector.resolveDependency(er, null);
	}

}
