package org.simplextensions.registry;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.FooService;
import org.simplextensions.IFooService;
import org.simplextensions.registry.services.ServiceRegistry;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class ServiceRegistryTest {

	@Before
	public void before() {

	}

	@Test(expected = IllegalStateException.class)
	public void getServiceTestNotStarted() {
		ServiceRegistry sr = spy(new ServiceRegistry());

		sr.getService(IFooService.class);

	}

	@Test
	public void getServiceTest() {

		ServiceRegistry sr = spy(new ServiceRegistry());
		Extension extension = new Extension(mock(IExtensionRegistry.class), 
				mock(SimpleXtensionsBundle.class),
				FooService.class.getCanonicalName(), 
				"fooservice");
		extension.setPropertyValue(ServiceRegistry.EXTENSION_TYPE, new PropertyValue(ServiceRegistry.EXTENSION_TYPE_SERVICE));
		extension.setPropertyValue(ServiceRegistry.SERVICE_INTERFACE, new PropertyValue(IFooService.class));
		sr.addExtension(extension);

	}

	@Test
	public void getRemoveServiceTest() {

		ServiceRegistry sr = spy(new ServiceRegistry());
		FooService service = spy(new FooService());
		IExtensionRegistry er = mock(IExtensionRegistry.class);
		SimpleXtensionsBundle bundle = mock(SimpleXtensionsBundle.class);

		Extension extension = new Extension(er, bundle, FooService.class.getCanonicalName(), "fooservice");
		extension.setPropertyValue(ServiceRegistry.EXTENSION_TYPE, new PropertyValue(ServiceRegistry.EXTENSION_TYPE_SERVICE));
		extension.setPropertyValue(ServiceRegistry.SERVICE_INTERFACE, new PropertyValue(IFooService.class));
		when(er.createExecutable(same(extension))).thenReturn(service);
		
		sr.addExtension(extension);		
		sr.start(er);
		assertNotNull(sr.getService(IFooService.class));
		
		verify(service).start();		

		sr.removeExtension(extension);

		verify(service).stop();
		
		assertNull(sr.getService(IFooService.class));

		

	}

	@Test
	public void stopSRBeforeGetTest() {

		ServiceRegistry sr = spy(new ServiceRegistry());
		FooService service = spy(new FooService());
		IExtensionRegistry er = mock(IExtensionRegistry.class);
		SimpleXtensionsBundle bundle = mock(SimpleXtensionsBundle.class);

		Extension extension = new Extension(er, bundle, FooService.class.getCanonicalName(), "fooservice");
		extension.setPropertyValue(ServiceRegistry.SERVICE_INTERFACE, new PropertyValue(IFooService.class));
		extension.setPropertyValue(ServiceRegistry.EXTENSION_TYPE, new PropertyValue(ServiceRegistry.EXTENSION_TYPE_SERVICE));
		sr.addExtension(extension);
		when(er.createExecutable(same(extension))).thenReturn(service);

		sr.start(er);


		sr.stop(er);

		verify(service, times(0)).stop();
	}

	@Test
	public void stopSRAfterGetTest() {

		ServiceRegistry sr = spy(new ServiceRegistry());
		FooService service = spy(new FooService());
		IExtensionRegistry er = mock(IExtensionRegistry.class);
		SimpleXtensionsBundle bundle = mock(SimpleXtensionsBundle.class);

		Extension extension = new Extension(er, bundle, FooService.class.getCanonicalName(), "fooservice");
		extension.setPropertyValue(ServiceRegistry.SERVICE_INTERFACE, new PropertyValue(IFooService.class));
		extension.setPropertyValue(ServiceRegistry.EXTENSION_TYPE, new PropertyValue(ServiceRegistry.EXTENSION_TYPE_SERVICE));
		sr.addExtension(extension);
		when(er.createExecutable(same(extension))).thenReturn(service);

		sr.start(er);

		assertNotNull(sr.getService(IFooService.class));


		sr.stop(er);

		verify(service, times(1)).stop();
	}
}
