package org.simplextensions.ui;

import org.simplextensions.properties.PropertiesReader;
import org.simplextensions.registry.services.Service;
import org.simplextensions.registry.services.Start;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Service that find simplextensions-ui.properties files and reads properties.
 * it uses {@link PropertiesReader} to find every simplextensions-ui.properties
 * file and merge values.
 * 
 * @see {@link PropertiesReader}
 * 
 * @author krzyzak
 * 
 */
@Service(ISimpleXtensionsUIService.class)
public class SimpleXtensionsUIService implements ISimpleXtensionsUIService {

	private static final Logger log = LoggerFactory.getLogger(SimpleXtensionsUIService.class);

	public final String PropertiesFileName = "simplextensions-ui.properties";

	private PropertiesReader propertiesReader;

	public SimpleXtensionsUIService() {

	}

	public SimpleXtensionsUIService(PropertiesReader propertiesReader) {
		this.propertiesReader = propertiesReader;
	}

	@Start
	public void start() {
		log.info("Starting " + getClass().getSimpleName());
		if (propertiesReader == null)
			propertiesReader = new PropertiesReader("simplextensions-ui.properties");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.simplextensions.ui.ISimpleXtensionsUIService#getProperty(java.lang
	 * .String)
	 */
	public String getProperty(String key) {
		String property = propertiesReader.getProperty(key);
		return property == null || "".equals(property) ? null : property;
	}

}
