package org.simplextensions.ui.settings.scanner;

import javassist.bytecode.annotation.Annotation;
import org.simplextensions.registry.*;
import org.simplextensions.scanner.ClassScannerHelper;
import org.simplextensions.ui.settings.SettingsExtensionPoint;

public class SettingsEditorScannPhaseListener implements ISimpleXtensionsClassScanner {

	public void scanClass(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {
		String id = ClassScannerHelper.getStringValue(a, "id");
		String parent = ClassScannerHelper.getStringValue(a, SettingsExtensionPoint.Param_Parent);
		if ("".equals(parent))
			parent = null;

		Extension extension = new Extension(extensionRegistry, bundle, className, id);
		extension.setPropertyValue(SettingsExtensionPoint.Param_Parent, new PropertyValue(parent));
		extensionRegistry.addExtension(extension, SettingsExtensionPoint.ID);
	}

}
