package org.simplextensions.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * 
 * if used on extensionpoint type implementing
 * 
 * @author Tomasz Krzyak, <a href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-29 21:56:35
 * 
 */
@Target(ElementType.TYPE)
public @interface Property {

	/**
	 * 
	 * @return
	 */
	String name();

	/**
	 * 
	 * value of property. it will be passed to instance of {@link ExtensionPoint}. 
	 * 
	 * @return
	 */
	String stringValue() default "";
	
	boolean boolValue() default false;
	
	int intValue() default 0;
	
	long longValue() default 0;
	
	Class<?> classValue() default void.class;


}
