package org.simplextensions.annotations;

/**
 * @author Tomasz Krzyak, <a href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-11-01 18:59:48
 * 
 */
public enum PropertyType {

	STRING(String.class), CLASS(Class.class), INTEGER(int.class), LONG(long.class), BOOLEAN(boolean.class);

	private final Class<?> clazz;

	private PropertyType(Class<?> clazz) {
		this.clazz = clazz;
	}

	public boolean isClassCompatible(Class<?> clazz) {
		return clazz == null || this.clazz.isAssignableFrom(clazz);
	}

}
