package org.simplextensions.graph;

/**
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-04-01 22:53:52
 */
public final class GraphLink {

	private final GraphNode startNode;
	private GraphNode endNode;
	private final String endNodeId;

	GraphLink(GraphNode startNode, String endNodeId) {
		this.startNode = startNode;
		this.endNodeId = endNodeId;
	}

	public GraphNode getEndNode() {
		return endNode;
	}

	void setEndNode(GraphNode endNode) {
		if (endNode != null) {
			if (!endNode.getId().equals(endNodeId))
				throw new RuntimeException(endNode.getId());
			endNode.innerAddIncoming(this);
		} else {
			if (this.endNode!=null){
				this.endNode.innerRemoveIncoming(this);
			}
		}
		this.endNode = endNode;
		this.startNode.checkFullyConnected();
	}

	public GraphNode getStartNode() {
		return startNode;
	}

	public String getEndNodeId() {
		return endNodeId;
	}

}
