/**
 * 
 */
package org.simplextensions.registry;

import java.util.Collection;
import java.util.Map;

import org.simplextensions.registry.phaselisteners.ICreationPhaseListener;
import org.simplextensions.registry.phaselisteners.IRegisterPhaseListener;
import org.simplextensions.registry.phaselisteners.IValidationPhaseListener;



/**
 * @author Tomasz Krzyak, <a href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-08-04 10:27:43
 * 
 */
public interface IExtensionRegistry {

	Collection<Extension> getExtensionsByClass(String name);
	Collection<ExtensionPoint> getExtensionPointsByClass(String name);
	ExtensionPoint getExtensionPoint(String extensionPointId);
	Collection<ExtensionPoint> getExtensionPoints();
	Collection<Extension> getExtensions(String extensionPointId);
	
	void addExtension(Extension extension);
	void addExtensionPoint(ExtensionPoint extensionPoint);
	void registerExtension(ExtensionPoint extensionPoint, Extension extension);
	Object createExecutable(ConfigurableElem configurableElem);
	Collection<Extension> getActiveExtensions(ExtensionPoint extensionPoint);
	
	Collection<? extends ICreationPhaseListener> getCreationListeners();
	Collection<? extends IValidationPhaseListener> getValidationListeners();
	Collection<? extends IRegisterPhaseListener> getRegisterListeners();
	Map<Class<?>, Map<Integer, Collection<IExtensionScanPhaseListener>>> getScanListeners();
	

	/*void addScannPhaseListener(Class<?> annotationClass, IExtensionScanPhaseListener listener, int level);
	void removeScannPhaseListener(Class<?> annotationClass, IExtensionScanPhaseListener listener, int level);
	
	void addValidatePhaseListener(IValidationPhaseListener listener);
	void removeValidatePhaseListener(IValidationPhaseListener listener);
	
	void addRegisterPhaseListener(IRegisterPhaseListener listener);
	void removeRegisterPhaseListener(IRegisterPhaseListener listener);
	
	
	void addCreationPhaseListener(ICreationPhaseListener listener);
	void removeCreationPhaseListener(ICreationPhaseListener listener);*/

	
	
}
