package org.simplextensions.registry.phaselisteners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simplextensions.annotations.ExtensionStyle;
import org.simplextensions.registry.ExtensionPoint;

public class ExtensionPointsCreationPhaseListeners extends APhaseListener implements ICreationPhaseListener {

	private static final Log log = LogFactory.getLog(ExtensionPointsCreationPhaseListeners.class);

	@Override
	public void processExtensionPoint(ExtensionPointEvent extensionPointEvent) {
		ExtensionPoint extensionPoint = extensionPointEvent.getExtensionPoint();
		if (ExtensionStyle.USER.equals(extensionPoint.getExtensionStyle())) {
			log.info("extension point: " + extensionPoint.getId() + " is user type");
			return;
		}
		extensionPoint.getExecutable();
	}

}
