/**
 * 
 */
package org.simplextensions.scanner;

import sun.reflect.annotation.AnnotationType;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;

/**
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-11-15 19:01:24
 * 
 */
public class ScannHelper {

	private static ArrayMemberValue memberValue;

	public static Annotation[] getAnnotationsValue(Annotation a, String memberName) {
			ArrayMemberValue amv = (ArrayMemberValue)a.getMemberValue(memberName);
			MemberValue[] value = amv.getValue();
			
			Annotation[] result = new Annotation[value.length];
			for (int i=0; i<value.length; i++){
				MemberValue mv = value[i];
				AnnotationMemberValue amv2 = (AnnotationMemberValue) mv;
				result[i] = amv2.getValue();
			}
			return result;
	}
	
	public static String[] getStringsValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getStringsValue(a, memberName, (String[]) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	public static String getStringValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getStringValue(a, memberName, (String) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	public static String[] getStringsValue(Annotation a, String memberName, String[] defaultValue) {
		memberValue = (ArrayMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			String[] result = new String[memberValue.getValue().length];
			int i = 0;
			for (MemberValue mv : memberValue.getValue()) {
				result[i++] = ((StringMemberValue) mv).getValue();
			}
			return result;
		} else
			return defaultValue;
	}

	public static String getStringValue(Annotation a, String memberName, String defaultValue) {
		StringMemberValue memberValue = (StringMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			return memberValue.getValue();
		} else
			return defaultValue;
	}

	public static Object getEnumValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return (Enum<?>) getEnumValue(a, memberName, (Enum<?>) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}

	}

	@SuppressWarnings("unchecked")
	public static <T extends Enum<?>> T getEnumValue(Annotation a, String memberName, T defaultValue) {

		Class class1;
		try {
			AnnotationType instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			class1 = instance.memberTypes().get(memberName);

			EnumMemberValue memberValue = (EnumMemberValue) a.getMemberValue(memberName);
			if (memberValue != null) {
				return (T) Enum.valueOf(class1, memberValue.getValue());
			} else
				return defaultValue;
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}

	}

	public static Class<?> getClassValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getClassValue(a, memberName, (Class<?>) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}
	public static Class<?>[] getClassesValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getClassesValue(a, memberName, (Class<?>[]) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	
	public static Class<?> getClassValue(Annotation a, String memberName, Class<?> defaultValue) throws ClassNotFoundException {
		ClassMemberValue memberValue = (ClassMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			return Class.forName(memberValue.getValue());
		} else
			return defaultValue;
	}
	
	public static Class<?>[] getClassesValue(Annotation a, String memberName, Class<?>[] defaultValue) throws ClassNotFoundException {
		ArrayMemberValue memberValue = (ArrayMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			MemberValue[] array = memberValue.getValue();
			Class<?>[] result = new Class[array.length];
			for (int i=0; i<array.length; i++){
				result[i] = Class.forName(((ClassMemberValue)array[i]).getValue());
			}
			return result;
		} else
			return defaultValue;
	}

	public static Boolean getBooleanValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getBooleanValue(a, memberName, (Boolean) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	public static Boolean getBooleanValue(Annotation a, String memberName, Boolean defaultValue) {
		BooleanMemberValue memberValue = (BooleanMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			return memberValue.getValue();
		} else
			return defaultValue;
	}

	public static Integer getIntegerValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getIntegerValue(a, memberName, (Integer) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	public static Integer getIntegerValue(Annotation a, String memberName, Integer defaultValue) {
		IntegerMemberValue memberValue = (IntegerMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			return memberValue.getValue();
		} else
			return defaultValue;
	}

	public static Long getLongValue(Annotation a, String memberName) {
		AnnotationType instance;
		try {
			instance = AnnotationType.getInstance(Class.forName(a.getTypeName()));
			return getLongValue(a, memberName, (Long) instance.memberDefaults().get(memberName));
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	public static Long getLongValue(Annotation a, String memberName, Long defaultValue) {
		LongMemberValue memberValue = (LongMemberValue) a.getMemberValue(memberName);
		if (memberValue != null) {
			return memberValue.getValue();
		} else
			return defaultValue;
	}

}
