package org.simplextensions;

import static junit.framework.Assert.assertNotNull;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.when;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;

import javax.xml.bind.JAXBException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.configuration.BundleConfiguration;
import org.simplextensions.configuration.ConfigurationReader;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.IService;

@RunWith(MockitoJUnitRunner.class)
public class SimplExtensionsTest {

	@Test
	public void testGetDefault() throws IOException, JAXBException {

		URL url = new File("./target/classes/extensions.xml").getCanonicalFile().toURI().toURL();

		Simplextensions spy = spy(Simplextensions.getInstance());
		BundleConfiguration read = ConfigurationReader.read(url);
		when(spy.getBundleList()).thenReturn(Arrays.asList(read));

		IExtensionRegistry default1 = spy.getDefault();
		assertNotNull(default1.getExtensionPoint(IService.EP_ID));
	}

}
