package org.simplextensions;

import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.assertTrue;

import java.util.Arrays;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class UtilsTest {

	@Test
	public void testMerge1() {
		List<String> asList = Arrays.asList(Utils.merge(new String[] { "", "1", null }, null, null, "2"));

		assertEquals(2, asList.size());
		assertTrue(asList.contains("1"));
		assertTrue(asList.contains("2"));
	}

	@Test
	public void testMerge2() {
		List<String> asList = Arrays.asList(Utils.merge(new String[] { "", "1", null }));

		assertEquals(1, asList.size());
		assertTrue(asList.contains("1"));
	}
	
	@Test
	public void testMerge3() {
		List<String> asList = Arrays.asList(Utils.merge(new String[] {}, null, null));

		assertEquals(0, asList.size());
	}

}
