package org.simplextensions.registry;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

import static org.mockito.Mockito.*;
import static junit.framework.TestCase.*;

@RunWith(MockitoJUnitRunner.class)
public class ServiceRegistryTest {

	private ServiceRegistry serviceRegistry;

	@Before
	public void setUp() {
		serviceRegistry = spy(new ServiceRegistry());
	}

	@After
	public void tearDown() {

	}

	@Test
	public void testNotStarterRegistry() {

		IFooService mock = mock(IFooService.class);
		serviceRegistry.registerService(IFooService.class, mock);

		verify(mock).init(eq(serviceRegistry));

		verifyNoMoreInteractions(mock);

		assertNull(serviceRegistry.getService(IFooService.class));

	}

	@Test
	public void testStarterRegistry() {

		IFooService mock = mock(IFooService.class);
		serviceRegistry.registerService(IFooService.class, mock);

		verify(mock).init(eq(serviceRegistry));

		serviceRegistry.start();

		verify(mock).start();

		verifyNoMoreInteractions(mock);

		assertNotNull(serviceRegistry.getService(IFooService.class));
	}

	@Test
	public void testStopServiceRegistry() {

		IFooService mock = mock(IFooService.class);
		serviceRegistry.registerService(IFooService.class, mock);
		serviceRegistry.start();
		assertNotNull(serviceRegistry.getService(IFooService.class));
		reset(mock);

		serviceRegistry.stop();
		verify(mock).stop();

		verifyNoMoreInteractions(mock);
	}

}
