package org.simplextensions.ui;

import javax.swing.JFrame;

import org.simplextensions.Simplextensions;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.ApplicationWindow;
import org.simplextensions.ui.menu.WindowMenuManager;

public class SwingApplicationWindow extends ApplicationWindow {

	private JFrame jFrame;
	private WindowMenuManager windowMenuManager;

	public SwingApplicationWindow() {
		this(Simplextensions.getInstance().getDefault());
	}

	public SwingApplicationWindow(IExtensionRegistry extensionRegistry) {
		super(extensionRegistry);
		this.jFrame = createJFrame();
		windowMenuManager = new WindowMenuManager(this, "mainMenu");
	}

	protected JFrame createJFrame() {
		JFrame jFrame = new JFrame();
		jFrame.setSize(300, 300);
		jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		return jFrame;
	}

	public WindowMenuManager getWindowMenuManager() {
		return windowMenuManager;
	}

	public JFrame getjFrame() {
		return jFrame;
	}

	public void open() {
		jFrame.setVisible(true);
	}

}
