package org.simplextensions.ui;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * basing implementation of {@link IStatefulControl}. it manages listeners and
 * allows to fire stateChange event
 * 
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-09 20:08:58
 */
public class AStatefulControl implements IStatefulControl {

	private static final Log log = LogFactory.getLog(AStatefulControl.class);

	private List<IStateListener> listeners = new LinkedList<IStateListener>();

	public void addStateChangeListener(IStateListener stateListener) {
		if (!listeners.contains(stateListener)) {
			listeners.add(stateListener);
		}
	}

	public void removeStateChangeListener(IStateListener stateListener) {
		listeners.remove(stateListener);
	}

	public void fireStateChanged(StateEvent stateEvent) {
		for (IStateListener listener : listeners) {
			try {
				listener.stateChanged(stateEvent);
			} catch (Exception e) {
				log.error("", e);
			}
		}
	}

}
