package org.simplextensions.ui;

import org.simplextensions.Simplextensions;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.menu.MenuExtensionPoint;

/**
 * Simple implementation of {@link IApplicationWindow}
 * 
 * 
 * @author Tomasz Krzyak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2010-05-10 09:56:53
 */
public class ApplicationWindow implements IApplicationWindow {

	private IExtensionRegistry extensionRegistry;

	public ApplicationWindow(IExtensionRegistry extensionRegistry) {
		this.extensionRegistry = extensionRegistry;
	}

	public ApplicationWindow() {
		this(Simplextensions.getInstance().getDefault());
	}

	public IExtensionRegistry getExtensionRegistry() {
		return this.extensionRegistry;
	}

	public MenuExtensionPoint getMenuExtensionPoint() {
		return (MenuExtensionPoint) this.extensionRegistry.getExtensionPoint(MenuExtensionPoint.ID).getExecutable();
	}

	// --------------- state listeners ----------------------

	private AStatefulControl sca = new AStatefulControl();

	public void addStateChangeListener(IStateListener stateListener) {
		sca.addStateChangeListener(stateListener);
	}

	public void removeStateChangeListener(IStateListener stateListener) {
		sca.removeStateChangeListener(stateListener);
	}

	protected void stateChanged(StateEvent stateEvent) {
		sca.fireStateChanged(stateEvent);
	}
}
