package org.simplextensions.ui.view;

import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.ui.IApplicationWindow;

public abstract class ViewManager<T extends IViewRegion> {

	private final IExtensionRegistry extensionRegistry;

	public ViewManager(IApplicationWindow applicationWindow) {
		this.extensionRegistry = applicationWindow.getExtensionRegistry();

		createContent();
	}

	protected void createContent() {
		
	}

	public void addView(IView<T> view) {
		T createViewRegion = createViewRegion(view);
		view.init(createViewRegion);

		view.createView();
	}

	public IExtensionRegistry getExtensionRegistry() {
		return extensionRegistry;
	}

	protected abstract T createViewRegion(IView<T> view);

}
