package org.simplextensions.registry;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.Simplextensions;
import org.simplextensions.ui.ISimpleXtensionsUIService;
import org.simplextensions.ui.menu.MenuExtensionPoint;
import org.simplextensions.ui.preferences.IPreferencesService;
import org.simplextensions.ui.preferences.xml.XMLPreferencesPersister;

import static junit.framework.TestCase.*;

@RunWith(MockitoJUnitRunner.class)
public class ExtensionRegistryTest {

	
	@Before
	public void setUp() {
		System.out.println("---------------------------------------------------------------------");
	}

	@After
	public void tearDown() {

	}
	
	@Test
	public void testScan() {
		System.out.println("Scan started");
		
		IExtensionRegistry default1 = Simplextensions.getInstance().createNewRegistry();
		IServiceRegistry serviceRegistry = (IServiceRegistry) default1.getExtensionPoint(IService.EP_ID).getExecutable();

		System.out.println("Scan finished");
		
		assertNotNull(default1.getExtensionPoint(MenuExtensionPoint.ID));
		
		assertNotNull(serviceRegistry);
		assertNotNull(serviceRegistry.getService(ISimpleXtensionsUIService.class));
		assertNotNull(serviceRegistry.getService(IPreferencesService.class));
	}

	@Test
	public void testExtensionServiceRegistriesTies() {
		System.out.println("Scan started");
		
		IExtensionRegistry default1 = Simplextensions.getInstance().createNewRegistry();
		IServiceRegistry serviceRegistry = (IServiceRegistry) default1.getExtensionPoint(IService.EP_ID).getExecutable();

		System.out.println("Scan finished");
		
		assertNotNull(serviceRegistry);
		assertNotNull(serviceRegistry.getService(IExtensionRegistry.class));
		
		ISimpleXtensionsUIService service = serviceRegistry.getService(ISimpleXtensionsUIService.class);
		assertNotNull(service);
		
		assertEquals(System.getProperty("user.home")+"/SimpleXtensions/Preferences", service.getProperty(XMLPreferencesPersister.XMLStorageDirProperty));
		
		assertNotNull(serviceRegistry.getService(IPreferencesService.class));
		
		assertNotNull(default1.getExtensionPoint(MenuExtensionPoint.ID));
	}

}
