package org.simplextensions.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import org.simplextensions.annotations.Property;

@Property(name = "mirek", longValue = 1)
public class AnnotationInfo {
	private Annotation annotation;
	private Map<String, Object> annotationValues = new HashMap<String, Object>();

	private AnnotationInfo(Annotation annotation) {
		this.annotation = annotation;
	}

	public static AnnotationInfo generateAnnotationInfo(Annotation annotation) {
		AnnotationInfo annotationInfo = new AnnotationInfo(annotation);
		try {
			generateInfoStructure(annotationInfo);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return annotationInfo;
	}

	private static void generateInfoStructure(AnnotationInfo annotationInfo)
			throws Exception {
		Class<? extends Annotation> annotationType = annotationInfo.annotation
				.annotationType();
		Map<String, Object> annotationValues = annotationInfo.annotationValues;
		Method[] declaredMethods = annotationType.getDeclaredMethods();
		for (Method method : declaredMethods) {
			if (!method.getDeclaringClass().equals(Annotation.class)) {
				method.setAccessible(true);
				Object value = method.invoke(annotationInfo.annotation);
				annotationValues.put(method.getName(), value);
			}
		}
	}

	public Object getAnnotationValue(String key) {
		return annotationValues.get(key);
	}

	public Annotation getAnnotation() {
		return annotation;
	}

}
